<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function purchases()
    {
        return $this->hasMany('App\Models\Purchase');
    }

    public function chats()
    {
        return $this->hasMany('App\Models\Chat');
    }

    public function connections()
    {
        return $this->hasMany('App\Models\Conection');
    }

    public function historicalLevels()
    {
        return $this->hasMany('App\Models\HistoricalLevel');
    }

    public function frienships()
    {
        return $this->hasMany('App\Models\Friendship');
    }

    public function enrollments()
    {
        return $this->hasMany('App\Models\Enrollment');
    }

    public function problemsSummary()
    {
        return $this->hasMany('App\Models\ModuleProblemUserSummary');
    }

    public function problemsAttempted()
    {
        return $this->hasMany('App\Models\ModuleProblemUserAttempted');
    }

    public function reachedAchiements()
    {
        return $this->hasMany('App\Models\ReachedAchievements');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification');
    }

}